<?php
define('access', 'cron');
include("webengine/config.php");
include($config_launcher['path_root'] . "webengine.php");

$width = isset($_GET['width']) ? intval($_GET['width']) : 1038;
$height = isset($_GET['height']) ? intval($_GET['height']) : 570;

$WEB_BASE_URL=($config_launcher['custom_url_enable']==true ? $config_launcher['custom_url_link'] : __BASE_URL__);

$castleSiege = new CastleSiege();
if (!$castleSiege->showWidget()) return;
$siegeData = $castleSiege->siegeData();
if (!is_array($siegeData)) return;

if ($siegeData['castle_data']["CASTLE_OCCUPY"] == 1) {
    $guildOwner = $siegeData['castle_data']["OWNER_GUILD"];
    $guildOwnerMark = $siegeData['castle_owner_alliance'][0]["G_Mark"];
    $guildMaster = $siegeData['castle_owner_alliance'][0]["G_Master"];
} else {
    $guildOwner = '-';
    $guildOwnerMark = '1111111111111111111111111114411111144111111111111111111111111111';
    $guildMaster = '-';
}
$rk_castle_img_logo=($config_launcher['custom_url_enable']==true ? str_replace(__BASE_URL__,$config_launcher['custom_url_link'],returnGuildLogo($guildOwnerMark, 100)) : returnGuildLogo($guildOwnerMark, 100));

function DetectisBase64($string) {
    if (preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $string) && strlen($string) % 4 === 0) {
        $decoded = base64_decode($string, true);
        if ($decoded !== false && base64_encode($decoded) === $string) {
            return $decoded;
        }
    }
    return false;
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZeroLauncher - News</title>
    <link href="webengine/css/style.css" rel="stylesheet" media="screen">
    <style>
    html, body {
            margin: 0;
            padding: 0;
            width: <?= $width ?>px;
            height: <?= $height ?>px;
            overflow: hidden;
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            background-color: transparent;
        }
    </style>
</head>

<body>
    <div id="container" class="container">
        <div id="content-zone">
            <div id="div_news" class="col-xs-6" style="/*width: 520px*/">
                <div class="newsBlock ">

                    <div class="h2-title flex-s-c">
                        <span>Last News</span> <a target="_blank" href="<?php echo $WEB_BASE_URL; ?>news">All news</a>
                    </div>

                    <?php
                    $cachedNews = loadCache('news.cache');
                    if (is_array($cachedNews)) {
                        $i=1;
                        foreach ($cachedNews as $newsArticle) {
                            if($i<=$config_launcher['top_news']){
                                echo '<div class="newsLink newsLink-events flex-s-c">
                                        <div class="newsLink-info">
                                            <a target="_blank" href="' . $WEB_BASE_URL . 'news/' . $newsArticle['news_id'] . '"><span style="color: #e45050 !important;">[News]</span> ' . (DetectisBase64($newsArticle['news_title']) ? base64_decode($newsArticle['news_title']) : $newsArticle['news_title']) . '</a>
                                            <span>' . date("l, F jS Y", $newsArticle['news_date']) . '</span>
                                        </div>
                                        <a target="_blank" href="' . $WEB_BASE_URL . 'news/' . $newsArticle['news_id'] . '" class="newsLink-more"><span>Read More</span></a>
                                    </div>';
                                $i++;
                            }
                        }
                    }
                    ?>
                </div>
            </div>

            <div id="div_top" class="col-xs-6" style="/*width: 518px*/">
                <div id="div_top_resets" class="col-xs-6" style="/*width: 259px*/">
                    <?php
                    //Top Reset
                    $topResets = LoadCacheData('rankings_resets.cache');
                    $topLevelLimit = $config_launcher['top_resets'];
                    if (is_array($topResets)) {
                        $showPlayerCountry = mconfig('show_country_flags') ? true : false;
                        $charactersCountry = loadCache('character_country.cache');
                        $topLevel = array_slice($topResets, 0, $topLevelLimit + 1);
                        echo '<div class="panel panel-sidebar fadeInLeft wow">';
                        echo '<div class="panel-heading">';
                        echo '<h3 class="panel-title">' . lang('rankings_txt_2') . '<a target="_blank" href="' . $WEB_BASE_URL . 'rankings/resets" class="btn btn-primary btn-xs pull-right" style="text-align:center;width:22px;">+</a></h3>';
                        echo '</div>';
                        echo '<div class="panel-body">';
                        echo '<table class="table table-condensed">';
                        echo '<thead>';
                        echo '<tr>';
                        echo '<th class="text-left">' . lang('rankings_txt_10') . '</th>'; // Character
                        echo '<th class="text-center">' . lang('rankings_txt_11') . '</th>'; // Class
                        echo '<th class="text-center">' . lang('rankings_txt_13') . '</th>'; // Reset
                        echo '</tr>';
                        echo '</thead>';
                        echo '<tbody>';
                        foreach ($topLevel as $key => $row) {
                            if ($key == 0) continue;
                            $rk_reset_img_flag=($config_launcher['custom_url_enable']==true ? str_replace(__BASE_URL__,$config_launcher['custom_url_link'],getCountryFlag($charactersCountry[$row[0]])) : getCountryFlag($charactersCountry[$row[0]]));
                            $rk_reset_profile=($config_launcher['custom_url_enable']==true ? str_replace(__BASE_URL__,$config_launcher['custom_url_link'],playerProfile($row[0])) : playerProfile($row[0]));
                            echo '<tr>';
                            echo '<td class="text-left"><img src="' . $rk_reset_img_flag . '" style="height:11px;" /> ' . $rk_reset_profile . '</td>';
                            echo '<td class="text-center">' . $custom['character_class'][$row[1]][1] . '</td>';
                            echo '<td class="text-center">' . number_format($row[2]) . '</td>';
                            echo '</tr>';
                        }
                        echo '</tbody>';
                        echo '</table>';
                        echo '</div>';
                        echo '</div>';
                    }
                    ?>
                </div>

                <div id="div_top_guild" class="col-xs-6" style="/*width: 259px*/">
                    <?php
                    //Top Guilds
                    $topGuilds = LoadCacheData('rankings_guilds.cache');
                    $topLevelLimit = $config_launcher['top_guilds'];
                    if (is_array($topGuilds)) {
                        $topLevel = array_slice($topGuilds, 0, $topLevelLimit + 1);
                        echo '<div class="panel panel-sidebar fadeInLeft wow">';
                        echo '<div class="panel-heading">';
                        echo '<h3 class="panel-title">' . lang('rankings_txt_4') . '<a target="_blank" href="' . $WEB_BASE_URL . 'rankings/guilds" class="btn btn-primary btn-xs pull-right" style="text-align:center;width:22px;">+</a></h3>';
                        echo '</div>';
                        echo '<div class="panel-body">';
                        echo '<table class="table table-condensed">';
                        echo '<thead>';
                        echo '<tr>';
                        echo '<th class="text-center">Guild</th>';
                        echo '<th class="text-center">Score</th>';
                        echo '<th class="text-center">Logo</th>';
                        echo '</tr>';
                        echo '</thead>';
                        echo '<tbody>';
                        foreach ($topLevel as $key => $row) {
                            if ($key == 0) continue;
                            $rk_guild_img_logo=($config_launcher['custom_url_enable']==true ? str_replace(__BASE_URL__,$config_launcher['custom_url_link'],returnGuildLogo($row[3], 11)) : returnGuildLogo($row[3], 11));
                            $rk_guild_profile=($config_launcher['custom_url_enable']==true ? str_replace(__BASE_URL__,$config_launcher['custom_url_link'],guildProfile($row[0])) : guildProfile($row[0]));
                            
                            echo '<tr>';
                            echo '<td class="text-center">' . $rk_guild_profile . '</td>';
                            echo '<td class="text-center">' . number_format($row[2]) . '</td>';
                            echo '<td class="text-center">' . $rk_guild_img_logo . '</td>';
                            echo '</tr>';
                        }
                        echo '</tbody>';
                        echo '</table>';
                        echo '</div>';
                        echo '</div>';
                    }
                    ?>
                </div>

            </div>

        </div>

        <div>



        </div>

        <!--MODULO Castle Siege-->
        <div class="castle-siege-banner fadeInDown wow">
            <div class="col-xs-2 text-center vcenter"><?php echo $rk_castle_img_logo; ?></div>
            <div class="col-xs-3 text-center vcenter">
                <div class="cstitle1">Castle Owner<br><span class="guild_owner"><?php echo $guildOwner; ?></span></div>
                <div class="cstitle2">Guild Master<br><span class="guild_master"><?php echo $guildMaster; ?></span></div>
            </div>
            <div class="col-xs-6 text-center vcenter" style="padding-top: 24px;">Castle Siege Battle<br><span class="guild_countdown" id="cscountdown"><?php echo $siegeData['warfare_stage_countdown']; ?></span></div>
        </div>
    </div>
</body>

</html>