<?php
define('access', 'cron');
include("custom/config.php");
$config_json = json_decode(file_get_contents('../config.json'), true);

$width = isset($_GET['width']) ? intval($_GET['width']) : 1038;
$height = isset($_GET['height']) ? intval($_GET['height']) : 570;

try {
    if ($config_json['server']['sql_driver'] == 2) {
        $this->db = new PDO("odbc:Driver={SQL Server};Server=".$config_json['server']['sql_host'].";Database=".$config_json['server']['sql_db']."; Uid=".$config_json['server']['sql_user'].";Pwd=".$config_json['server']['sql_pass'].";");
    }else{
        if ($config_json['server']['sql_driver'] == 1) {
            $pdo_connect = "sqlsrv:Server=" . $config_json['server']['sql_host'] . "," . $config_json['server']['sql_port'] . ";Database=" . $config_json['server']['sql_db'] . "";
        } else {
            $pdo_connect = 'dblib:host=' . $config_json['server']['sql_host'] . ':' . $config_json['server']['sql_port'] . ';dbname=' . $config_json['server']['sql_db'];
        }

        $db = new PDO($pdo_connect, $config_json['server']['sql_user'], $config_json['server']['sql_pass']);
    }
    
} catch (PDOException $e) {
    echo "Error de conexion: " . $e->getMessage();
    die();
}

$stmt = $db->prepare('SELECT * FROM MuCastle_DATA');
$stmt->execute();
$siegeData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $db->prepare("SELECT G_Mark,G_Master FROM Guild WHERE G_Name='".$siegeData[0]['OWNER_GUILD']."'");
$stmt->execute();
$guild_info = $stmt->fetchAll(PDO::FETCH_ASSOC);

if(!isset($guild_info[0]) || $guild_info[0]["G_Master"]==''){
    $siegeData[0]["CASTLE_OCCUPY"]=0;
}

if ($siegeData[0]["CASTLE_OCCUPY"] == 1) {
    $guildOwner = $siegeData[0]["OWNER_GUILD"];
    $guildOwnerMark = $guild_info[0]["G_Mark"];
    $guildMaster = $guild_info[0]["G_Master"];
} else {
    $guildOwner = '-';
    $guildOwnerMark = '1111111111111111111111111114411111144111111111111111111111111111';
    $guildMaster = '-';
}


?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZeroLauncher - News</title>
    <!-- Enlaces a hojas de estilo CSS o scripts adicionales -->
    <link href="custom/css/style.css" rel="stylesheet" media="screen">
    <style>
    html, body {
            margin: 0;
            padding: 0;
            width: <?= $width ?>px;
            height: <?= $height ?>px;
            overflow: hidden;
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            background-color: transparent;
        }
    </style>
</head>

<body>
    <!-- Contenido de la página -->
    <div id="container" class="container">
        <div id="content-zone">
            <div id="div_news" class="col-xs-6" style="/*width: 520px*/">
                <div class="newsBlock ">

                    <div class="h2-title flex-s-c">
                        <span>Last News</span>
                    </div>

                    <?php
                    $cachedNews = $config_json['client']['news'];
                    if (is_array($cachedNews)) {
                        $i = 1;
                        foreach ($cachedNews as $newsArticle) {
                            if ($i <= $config['top_news'] ) {
                                echo '<div class="newsLink newsLink-events flex-s-c">
                                        <div class="newsLink-info">
                                            <a target="_blank" href="' . $newsArticle['url_link'] . '"><span style="color: #e45050 !important;">[News]</span> ' . $newsArticle['title'] . '</a>
                                            <span>' . date("l, F jS Y", $newsArticle['date']) . '</span>
                                        </div>
                                        <a target="_blank" href="' . $newsArticle['url_link'] . '" class="newsLink-more"><span>Read More</span></a>
                                    </div>';
                                $i++;
                            }
                        }
                    }
                    ?>
                </div>
            </div>

            <div id="div_top" class="col-xs-6" style="/*width: 518px*/">
                <div id="div_top_resets" class="col-xs-6" style="/*width: 259px*/">
                    <?php
                    //Top Reset
                    $stmt = $db->prepare('SELECT TOP '.$config['top_resets'].' Name, cLevel, Class, ResetCount FROM Character ORDER BY ResetCount DESC');
                    $stmt->execute();

                    $topResets_query = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    if (is_array($topResets_query)) {

                        echo '<div class="panel panel-sidebar fadeInLeft wow">';
                        echo '<div class="panel-heading">';
                        echo '<h3 class="panel-title">TOP RESETS</h3>';
                        echo '</div>';
                        echo '<div class="panel-body">';
                        echo '<table class="table table-condensed">';
                        echo '<thead>';
                        echo '<tr>';
                        echo '<th class="text-center">Character</th>'; // Character
                        echo '<th class="text-center">Resets</th>'; // Resets
                        echo '<th class="text-center">Level</th>'; // Level
                        echo '</tr>';
                        echo '</thead>';
                        echo '<tbody>';
                        $topLevelLimit=1;
                        foreach ($topResets_query as $topResets) {
                            echo '<tr>';
                            echo '<td class="text-center"><b>' . $topResets['Name'] . '</b></td>';
                            echo '<td class="text-center">' . $topResets['ResetCount'] . '</td>';
                            echo '<td class="text-center">' . $topResets['cLevel'] . '</td>';
                            echo '</tr>';
                        }
                        echo '</tbody>';
                        echo '</table>';
                        echo '</div>';
                        echo '</div>';
                    }
                    ?>
                </div>

                <div id="div_top_guild" class="col-xs-6" style="/*width: 259px*/">
                    <?php
                    //Top Guilds
                    $stmt = $db->prepare('SELECT TOP '.$config['top_guilds'].' G_Name, G_Score, G_Mark FROM Guild ORDER BY G_Score DESC');
                    $stmt->execute();

                    $topGuilds_query = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    if (is_array($topGuilds_query)) {
                        echo '<div class="panel panel-sidebar fadeInLeft wow">';
                        echo '<div class="panel-heading">';
                        echo '<h3 class="panel-title">TOP GUILDS</h3>';
                        echo '</div>';
                        echo '<div class="panel-body">';
                        echo '<table class="table table-condensed">';
                        echo '<thead>';
                        echo '<tr>';
                        echo '<th class="text-center">Guild Name</th>'; // Character
                        echo '<th class="text-center">Score</th>'; // Class
                        echo '<th class="text-center">Guild Logo</th>'; // Level
                        echo '</tr>';
                        echo '</thead>';
                        echo '<tbody>';
                        foreach ($topGuilds_query as $topGuilds) {
                            echo '<tr>';
                            echo '<td class="text-center">' . $topGuilds['G_Name'] . '</td>';
                            echo '<td class="text-center">' . $topGuilds['G_Score'] . '</td>';
                            echo '<td class="text-center">' . returnGuildLogo($topGuilds['G_Mark'], 18) . '</td>';
                            echo '</tr>';
                        }
                        echo '</tbody>';
                        echo '</table>';
                        echo '</div>';
                        echo '</div>';
                    }
                    ?>
                </div>

            </div>

        </div>

        <div>



        </div>

        <!--MODULO Castle Siege-->
        <?php if($config['castle_siege_enable']) { ?>
        <div class="castle-siege-banner fadeInDown wow">
            <div class="col-xs-2 text-center vcenter"><?php echo returnGuildLogo($guildOwnerMark, 100); ?></div>
            <div class="col-xs-3 text-center vcenter">
                <div class="cstitle1">Castle Owner<br><span class="guild_owner"><?php echo $guildOwner; ?></span></div>
                <div class="cstitle2">Guild Master<br><span class="guild_master"><?php echo $guildMaster; ?></span></div>
            </div>
            <div class="col-xs-6 text-center vcenter" style="padding-top: 24px;">Castle Siege Battle<br><span class="guild_countdown" id="cscountdown"><?php echo TimeLeft($config['castle_siege_war_time']); ?></span></div>
        </div>
        <?php } ?>

    </div>
</body>

</html>