<?php
//Funciones Generales
function check_value($value) {
	if((@count($value)>0 and !@empty($value) and @isset($value)) || $value=='0') {
		return true;
	}
}
function savefile($file,$data){
	$f=@fopen($file, "a");
    @fwrite($f, "$data");
    @fclose($f);
}
function savefile2($file,$data){
	file_put_contents($file, $data);
}
function langC($phrase, $return=true) {
	global $lang;

	$result = $lang['client'][$phrase];
	if(!$result) $result = 'ERROR';
	
	if($return) {
		return $result;
	} else {
		echo $result;
	}
}

function langS($phrase, $return=true) {
	global $lang;

	$result = $lang['server'][$phrase];
	if(!$result) $result = 'ERROR';
	
	if($return) {
		return $result;
	} else {
		echo $result;
	}
}

function langApi($phrase, $return=true) {
	global $lang;

	$result = $lang['api'][$phrase];
	if(!$result) $result = 'ERROR';
	
	if($return) {
		return $result;
	} else {
		echo $result;
	}
}
//Fin funciones Generales
 function saveconfig($array){
	try {
		$cfgtmp = json_decode(file_get_contents('config.json'),true);
		
		# Seccion Server
		if(isset($array['server'])){
			foreach($array['server'] as $key => $val){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp['server'][$key] = $val;
			}
		}
		# Seccion Client
		if(isset($array['client'])){
			foreach($array['client'] as $key => $val){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp['client'][$key] = $val;
			}
		}
		# Key Generales
		foreach($array as $key => $val){
			if(!is_array($cfgtmp[$key])){
				if($val=="True" || $val=="true"){
					$val=true;
				}else if($val=="False" || $val=="False"){
					$val=false;
				}
				$cfgtmp[$key] = $val;
			}
		}
		$tmpjson = json_encode($cfgtmp, JSON_PRETTY_PRINT);
		$cfgFiletmp = fopen('config.json', 'w');
		fwrite($cfgFiletmp, $tmpjson);
		fclose($cfgFiletmp);

		$rp['status']=true;
		$rp['msg']='Config saved successfully';
	} catch (Exception $e) {
		$rp['status']=false;
		$rp['msg']=$e->getMessage();
	}
	return $rp;
 }

 function userExists($username) {
	global $config;
	if(!Validator::UsernameLength($username)) return;
	if(!Validator::AlphaNumeric($username)) return;


	$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

	$result = $mudb->query_fetch_single("SELECT * FROM MEMB_INFO WHERE memb___id = ?", array($username));

	if(is_array($result)) return true;
	return;
}

function emailExists($email) {
	global $config;
	if(!Validator::Email($email)) return;

	$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

	$result = $mudb->query_fetch_single("SELECT * FROM MEMB_INFO WHERE mail_addr = ?", array($email));
	if(is_array($result)) return true;
	return;
}

 function register($values){
	global $config;
	//Comparamos cual DDL esta cargada
	try{

		if($config['server']['sql_driver']!=0 && $config['server']['sql_driver']!=1 && $config['server']['sql_driver']!=2){
		    throw new Exception("Driver SQL Not found.");
		}
		$mudb = new dB($config['server']['sql_host'], $config['server']['sql_port'], $config['server']['sql_db'], $config['server']['sql_user'], $config['server']['sql_pass'], $config['server']['sql_driver']);

		if($mudb->dead) {
			throw new Exception("Could not connect to database");
		}
		

		//Validamos datos
		if(!check_value($values['user'])) throw new Exception(langApi('error_1',true));
		if(!check_value($values['pass'])) throw new Exception(langApi('error_1',true));
		if(!check_value($values['email'])) throw new Exception(langApi('error_1',true));

		if(!Validator::UsernameLength($values['user'])) throw new Exception(langApi('error_2',true));
		if(!Validator::AlphaNumeric($values['user'])) throw new Exception(langApi('error_3',true));
		if(!Validator::PasswordLength($values['pass'])) throw new Exception(langApi('error_4',true));
		if(!Validator::Email($values['email'])) throw new Exception(langApi('error_5',true));

		if(userExists($values['user'])) throw new Exception(langApi('error_7',true));
		if(emailExists($values['email'])) throw new Exception(langApi('error_8',true));

		$data = array(
			'username' => $values['user'],
			'password' => $values['pass'],
			'name' => $values['user'],
			'serial' => '1111111111111',
			'email' => $values['email']
		);

		$query = "INSERT INTO MEMB_INFO (memb___id, memb__pwd, memb_name, sno__numb, mail_addr, bloc_code, ctl1_code) VALUES (:username, :password, :name, :serial, :email, 0, 0)";

		# create account
		$result = $mudb->query($query, $data);
		if(!$result) throw new Exception(langApi('error_6',true));

		$rp['status']=true;
		$rp['msg']=langApi('success_1', true);

	} catch (Exception $e) {
		$rp['status']=false;
		$rp['msg']=$e->getMessage();
	}
	return $rp;
 }